<?php

namespace App\Http\Controllers;

use App\Models\CompanyInformation;
use Inertia\Inertia;
use Illuminate\Http\Request;
use Illuminate\Validation\ValidationException;
use Illuminate\Support\Facades\Redirect;
use DB;

class CompanyInformationController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(CompanyInformation $companyInformation)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(CompanyInformation $companyInformation)
    {
        //
        $company_information = CompanyInformation::firstOrFail();

        return Inertia::render('CompanyInfo', [
            'company_information' => $company_information,
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request)
    {
        //
        try{
            DB::beginTransaction();
            $validatedData = $request->validate([
                'introduction' => 'required|min:20',
                'mission' => 'required|min:10',
                'vision' => 'required|min:10',
                'objectives' => 'required|min:20',
                'address' => 'required',    
                'phone' => 'required',
                'email' => 'required|email',
                'facebook' => 'required|url',
                'instagram' => 'required|url',
                'youtube' => 'required|url',
                'tiktok' => 'required|url',
                'story' => 'nullable|min:20',
                'about' => 'nullable|min:20',
                'map_embed_code' => 'nullable|string',
                'whatsapp_marketing' => 'nullable|string|max:255',
                'whatsapp_reception' => 'nullable|string|max:255',
                'menu_title' => 'nullable|string|max:255',
                'menu_description' => 'nullable|string',
                'cta_title' => 'nullable|string|max:255',
                'rooms_description' => 'nullable|string',
                'photos_description' => 'nullable|string',
                'offers_description' => 'nullable|string',
                'events_description' => 'nullable|string',

            ]);

            $info = CompanyInformation::firstOrFail();
            $info->fill($validatedData);
            if($info->isDirty()){
                $info->save();
            }

            DB::commit();
            return Redirect::back()->with('success', [
                'message' => 'Details updated successfully',
                'check'   => false
            ]);
        } catch (ValidationException $e){
            DB::rollBack();
            return redirect()->back()
                ->withErrors($e->errors()) 
                ->withInput(); 

        } catch (\Exception $e) {
            DB::rollBack();
            return redirect()->back()->with('error', [
                'message' => 'An error occurred:' . $e->getMessage(),
                'check'   => false
            ]);
        }
        
    
        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(CompanyInformation $companyInformation)
    {
        //
    }
}
