<?php

namespace App\Http\Controllers;

use App\Models\Banner;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Auth;
use Inertia\Inertia;
use Illuminate\Http\JsonResponse;
use Illuminate\Validation\ValidationException;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Storage;
use DB;
use App\Traits\DeleteModelTrait; 

class BannerController extends Controller
{
    
    use DeleteModelTrait;
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //

    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        try{
            DB::beginTransaction();
            $validatedData = $request->validate([
                'title' => 'required|min:3', 
                'content' => 'nullable|string',
                'status' => 'required',
                'photo' => 'required',
            ]);

            if ($validatedData['status'] == true) {
                Banner::where('status', true)->update(['status' => false]);
            }

            $banner = new Banner;
            $banner->title = $validatedData['title'];
            $banner->content = $validatedData['content'] ?? null;
            $banner->status = $validatedData['status'];
            $banner->photo = $validatedData['photo'];
            $banner->save();

            DB::commit();
            return to_route('admin.banners')->with('success', [
                'message' => 'Banner created successfully',
                'check' => false
            ]);
        } catch (ValidationException $e){
            DB::rollBack();
            return redirect()->back()
                ->withErrors($e->errors()) 
                ->withInput(); 

        } catch(\Exception $e) {
            DB::rollBack();
            return Redirect::back()->with('error', [
                'message' => 'Error: '.$e->getMessage(),
                'check' => $e->getMessage()
            ]);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(Banner $banner)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        $banner = Banner::findOrFail($id);
        return response()->json($banner);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        try {
            DB::beginTransaction();
            $validatedData = $request->validate([
                'title' => 'required|min:3', 
                'content' => 'nullable|string',
                'status' => 'required',
                'photo' => 'required',
            ]);

            $banner = Banner::findOrFail($id);

            if ($validatedData['status'] == true) {
                Banner::where('status', true)->update(['status' => false]);
            }
            
            $banner->fill($validatedData);
            if ($banner->isDirty()){
                $banner->save();
            }

            DB::commit();

            return Redirect::back()->with('success', [
                'message' => 'Banner updated successfully',
                'check'   => false
            ]);
        } catch (ValidationException $e) {
            DB::rollBack();
            return Redirect::back()->with('error', [
                'message' => 'Validation error: ' . $e->getMessage(),
                'check'   => $e->getMessage()
            ]);
        } catch (\Exception $e) {
            DB::rollBack();
            return Redirect::back()->with('error', [
                'message' => 'Error: ' . $e->getMessage(),
                'check'   => $e->getMessage()
            ]);
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        //
        return $this->deleteModel($id, new Banner());
    }

    public function fetchBanners()
    {
        $banners = Banner::orderBy('created_at', 'desc')->get();
        return Inertia::render('banners/Banner', [
            'banners' => $banners->map(function ($banner) {
                return $banner->only('id', 'title', 'content', 'photo', 'status', 'created_at');
            }),
        ]);
    }

    public function uploadImage(Request $request)
    {
        $request->validate([
            'file' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:5048',
        ]);
        $path = $request->file('file')->store('banner-images', 'public');  
        $filename = basename($path); 

        return response()->json(['filename' => 'banner-images/' . $filename]); 
    }
}
