# Matergo Hotel Website

A website  built for Matergo Hotel in Gitega, Burundi. This full-stack application provides accommodation booking, dining services, event management, and a complete content management system.

## Features

### Public Website
- **Accommodation Booking**: Browse and book room types (Simple, Standard, Golden, Silver, VIP)
- **Dining Menu**: Browse food, drinks, and desserts with detailed descriptions
- **Event & Conference Rooms**: View and inquire about meeting facilities
- **Gallery**: Photo gallery showcasing hotel facilities
- **Blog**: News and updates about the hotel
- **Testimonials**: Guest reviews and feedback
- **Contact Form**: Direct communication with the hotel
- **About Us**: Information about the hotel's mission, vision, and story

### Admin Dashboard
- **Accommodation Management**: Create, update, and manage room types and availability
- **Event Room Management**: Manage conference and event facilities
- **Booking Management**: View, confirm, and manage reservations
- **Menu Management**: Manage dining menu items (Food, Drinks, Desserts)
- **Content Management**: 
  - Blog posts and categories
  - Testimonials
  - FAQs
  - Gallery images
  - Banners and sliders
- **Contact Management**: View and respond to customer inquiries
- **User Management**: Admin user accounts with role-based permissions
- **Company Information**: Manage hotel details, social links, and settings
- **Dashboard Analytics**: Statistics and overview of bookings and activities

## Tech Stack

### Backend
- **PHP 8.2+**
- **Laravel 11**
- **MySQL Database**
- **Laravel Inertia.js** (for seamless SPA experience)

### Frontend
- **React 19**
- **Inertia.js** (React adapter)
- **TailwindCSS** (styling)
- **Vite** (build tool)
- **React Hot Toast** (notifications)

### Additional Packages
- **Spatie Laravel Permission**: Role-based access control
- **Owen It Laravel Auditing**: Activity logging
- **React Turnstile**: Cloudflare CAPTCHA integration
- **Date-fns**: Date manipulation

## Requirements

- PHP >= 8.2
- Composer
- Node.js >= 18.x
- npm or yarn
- MySQL >= 8.0

## Installation

1. **Clone the repository**
   ```bash
   git clone https://github.com/Ufanisia-Africa/matergo_website.git
   cd matergo_website
   ```

2. **Install PHP dependencies**
   ```bash
   composer install
   ```

3. **Install Node.js dependencies**
   ```bash
   npm install
   ```

4. **Environment setup**
   ```bash
   cp .env.example .env
   php artisan key:generate
   ```
   
   Configure your `.env` file with database credentials and other settings:
   ```env
   DB_CONNECTION=mysql
   DB_HOST=127.0.0.1
   DB_PORT=3306
   DB_DATABASE=matergo
   DB_USERNAME=your_username
   DB_PASSWORD=your_password
   ```

5. **Run database migrations**
   ```bash
   php artisan migrate
   php artisan db:seed
   ```

6. **Build assets**
   ```bash
   npm run build
   ```

## Development

### Start development servers

The project includes a convenient development script that runs all services concurrently:

```bash
composer run dev
```

This command starts:
- Laravel development server
- Queue worker
- Log viewer (Pail)
- Vite dev server

Alternatively, you can run services individually:

```bash
# Terminal 1: Laravel server
php artisan serve

# Terminal 2: Vite dev server
npm run dev


### Access the application

- **Public website**: http://localhost:8000
- **Admin panel**: http://localhost:8000/admin/login

## Project Structure

```
matergo/
├── app/
│   ├── Http/
│   │   ├── Controllers/     # API and web controllers
│   │   └── Middleware/      # Custom middleware
│   ├── Mail/                # Email templates
│   ├── Models/              # Eloquent models
│   └── Traits/              # Reusable traits
├── database/
│   ├── migrations/          # Database schema
│   └── seeders/             # Database seeders
├── public/                  # Public assets and entry point
├── resources/
│   ├── js/
│   │   ├── admin/           # Admin React components
│   │   ├── user/            # Public website React components
│   │   └── bootstrap.js     # Application bootstrap
│   └── views/               # Blade templates (Inertia root)
├── routes/
│   └── web.php              # Application routes
└── vite.config.js           # Vite configuration
```

## Key Models

- `Accommodation` - Room types and details
- `Booking` - Reservation records
- `EventRoom` - Conference and event facilities
- `MenuItem` - Dining menu items
- `Post` - Blog posts
- `Testimonial` - Guest testimonials
- `Contact` - Contact form submissions
- `User` - Admin users
- `CompanyInformation` - Hotel settings and information
